<?php

namespace App\Notifications;

use App\Clients\WaNotifClient;
use App\Notifications\Channels\WaChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SubscriptionInactive extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    protected $subscription;
    public function __construct($subscription)
    {
        $this->subscription = $subscription;
    }



    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', WaChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->line('Halo ' . $notifiable->name . '!')
            ->line('Langganan anda untuk ' . $this->subscription->product . ' ' .  ' ' . ($this->subscription->domain) . ' telah dinonaktifkan.')
            ->line('Terima kasih telah menggunakan layanan kami!')
            ->line('regards,', config('app.name'));
    }

    public function toWa($notifiable)
    {
        return (new WaNotifClient())
            ->line('Halo ' . $notifiable->name . '!')
            ->line('Langganan anda untuk ' . $this->subscription->product . ' ' .  ' ' . ($this->subscription->domain) . ' telah dinonaktifkan.')
            ->line()
            ->line('Terima kasih telah menggunakan layanan kami!')
            ->line('regards,', config('app.name'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
