<?php

namespace App\Notifications;


use App\Clients\WaNotifClient;
use App\Notifications\Channels\WaChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class NewInvoice extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    private $payment;
    public function __construct($payment)
    {
        $this->payment = $payment;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', WaChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject("Invoice #{$this->payment->id}")
            ->line('Halo, ' . $notifiable->name)
            ->line('Berikut adalah invoice pembayaran anda')
            ->line('Nomor Invoice: ' . $this->payment->id)
            ->line('Jumlah Pembayaran: ' . number_format($this->payment->amount, 0, ',', '.'))
            ->line('Keterangan: ' . $this->payment->description)
            ->line('--------------------------------------------------')
            ->line('Anda dapat melakuka pembayaran sebelum ' . $this->payment->expired_at)
            ->action('Lihat Invoice', route('invoices.detail', $this->payment->invoice_number))
            ->line('Terima kasih telah menggunakan layanan kami')
            ->line('Regards,' . config('app.name'));
    }

    public function toWa(object $notifiable)
    {
        return (new WaNotifClient())
            ->bold('Halo, ' . $notifiable->name)->line()
            ->line('Berikut adalah invoice pembayaran anda')->line()
            ->line('Nomor Invoice: ' . $this->payment->id)
            ->line('Jumlah Pembayaran: ' . number_format($this->payment->amount, 0, ',', '.'))
            ->line('Keterangan: ' . $this->payment->description)
            ->line('--------------------------------------------------')
            ->line('Anda dapat melakuka pembayaran sebelum ' . $this->payment->expired_at)
            ->line('Selengkapnya ' . route('invoices.detail', $this->payment->invoice_number))
            ->line()->line()
            ->line('Terima kasih telah menggunakan layanan kami')
            ->line('Regards,')->bold(config('app.name'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */

    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
