<?php

namespace App\Notifications;

use App\Clients\WaNotifClient;
use App\Notifications\Channels\WaChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class InvoicePaid extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    protected $payment;
    public function __construct($payment)
    {
        $this->payment = $payment;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', WaChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->line('Tagihan . #' . $this->payment->id . ' telah dibayar')
            ->line("Halo " . $notifiable->name . ", Tagihan anda *" . $this->payment->description . "* sebesar Rp. " . number_format($this->payment->amount, 0, ',', '.') . " telah dibayar.")
            ->line('Terima kasih telah menggunakan layanan kami')->line("")
            ->line('Regards,' . config('app.name'));
    }

    public function toWa(object $notifiable)
    {
        return (new WaNotifClient())
            ->bold('Tagihan #' . $this->payment->id . " telah dibayar")->line()
            ->line("Tagihan anda *" . $this->payment->description . "* sebesar Rp. " . number_format($this->payment->amount, 0, ',', '.') . " telah dibayar.")
            ->line()->line()
            ->line('Terima kasih telah menggunakan layanan kami')
            ->line('Regards,' . config('app.name'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
