<?php

namespace App\Notifications;

use App\Clients\WaNotifClient;
use App\Notifications\Channels\WaChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class InvoiceCanceled extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    protected  $payment;
    public function __construct($payment)
    {
        $this->payment = $payment;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', WaChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->line("Tagihan #" . $this->payment->id . " telah dibatalkan.")
            ->action('Halo .', $notifiable->name . " Tagihan #" . $this->payment->id . " dengan nominal " . $this->payment->amount . " telah dibatalkan.")
            ->line('Terima kasih telah menggunakan aplikasi kami!')
            ->line('regards,', config('app.name'));
    }

    public function toWa($notifiable)
    {
        return (new WaNotifClient())
            ->line("Tagihan #" . $this->payment->id . " telah dibatalkan.")
            ->line('Halo ' . $notifiable->name . " Tagihan #" . $this->payment->id . " dengan nominal " . $this->payment->amount . " telah dibatalkan.")
            ->line()
            ->line('Terima kasih telah menggunakan layanan kami!')
            ->line('regards,', config('app.name'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */

    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
