<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    protected $guarded = ['id'];



    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
    public function lastPayment()
    {
        return $this->hasOne(Payment::class)->latestOfMany();
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function server()
    {
        return $this->belongsTo(Server::class);
    }


    public function socials()
    {
        return $this->hasMany(SocialChannel::class);
    }
}
