<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    protected $fillable = [
        'invoice_number',
        'description',
        'user_id',
        'subscription_id',
        'amount',
        'is_manual',
        'status',
        'payment_details',
        'expired_at',
        'tax',
        'payment_type',
    ];

    protected $dates = ['expired_at'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subscription()
    {
        return $this->belongsTo(Subscription::class);
    }
}
