<?php

namespace App\Libs;

class Helper
{

    public static function isDomain($domain)
    {
        // Daftar TLD panjang yang lebih lengkap
        $tlds = [
            'ac.id',
            'co.id',
            'go.id',
            'or.id',
            'web.id',
            'my.id',
            'sch.id', // TLD Indonesia
            'com.au',
            'net.au',
            'org.au',
            'gov.au',
            'edu.au',
            'asn.au', // TLD Australia
            'co.uk',
            'org.uk',
            'ac.uk',
            'gov.uk',
            'edu.uk',
            'ltd.uk', // TLD UK
            'com.my',
            'net.my',
            'org.my',
            'edu.my', // TLD Malaysia
            'co.in',
            'org.in',
            'gen.in',
            'ind.in', // TLD India
            'com.sg',
            'net.sg',
            'org.sg',
            'edu.sg', // TLD Singapore
            'co.za',
            'org.za',
            'gov.za', // TLD South Africa
            'ca',
            'us',
            'jp',
            'de',
            'fr',
            'it',
            'es',
            'br',
            'ru',
            'eu', // TLD negara lainnya
            'info',
            'biz',
            'name',
            'mobi',
            'tel',
            'co',
            'me',
            'tv',
            'asia' // TLD umum
        ];

        // Pecah domain menjadi bagian-bagian
        $parts = explode('.', $domain);

        // Jika domain memiliki lebih dari 2 bagian dan bagian terakhir adalah TLD panjang
        if (count($parts) > 2 && in_array(implode('.', array_slice($parts, -2)), $tlds)) {
            return true; // Ini adalah domain utama (bukan subdomain)
        }

        // Memeriksa apakah domain hanya memiliki satu titik, berarti domain utama level pertama
        return substr_count($domain, '.') == 1;
    }
}
