<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class OrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'product_id' => 'required|exists:products,id',
            'package_id' => 'required|exists:product_packages,id',
            'domain_option' => 'required|in:own,sub',
            'domain' => 'required_if:domain_option,own|max:255',
            'domain'        => [
                'required',
                'string',
                'max:255',
                function ($attribute, $value, $fail) {
                    $domainOption = request('domain_option');
                    $appDomain = env('APP_DOMAIN');

                    if ($domainOption === 'sub') {
                        if (str_contains($value, '.')) {
                            return $fail("Subdomain tidak boleh mengandung titik.");
                        }

                        $fullDomain = "{$value}.{$appDomain}";
                    } else {
                        $fullDomain = $value;
                    }

                    $exists = DB::table('subscriptions')
                        ->where('domain', $fullDomain)
                        ->where('status', 'active')
                        ->exists();

                    if ($exists) {
                        return $fail("Domain ini sudah digunakan.");
                    }
                }
            ]
            //  'subdomain' => 'required_if:domain_option,sub|string|max:255|unique:subscriptions,domain', // Pastikan tidak ada subdomain yang sama
        ];

        // Tambahkan validasi untuk name, email, dan password jika pengguna belum login
        if (!Auth::check()) {
            $rules['name'] = 'required|max:255';
            $rules['email'] = 'required|email|max:255|unique:users,email';
            $rules['password'] = 'required|min:6';
            $rules['whatsapp'] = 'required|max:20|unique:users,whatsapp';
        }

        return $rules;
    }
}
