<?php

namespace App\Http\Controllers;

use App\Models\Product;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    public function index()
    {
        $products = Product::with(['packages' => function ($query) {
            $query->orderBy('price', 'asc')->limit(1); // Ambil 1 package dengan harga terkecil
        }])->get();
        return view('products.index', compact('products'));
    }

    public function show(Product $product)
    {
        $product->load('packages');
      
        return view('products.show', compact('product'));
    }
}
