<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user()->loadCount([
            'subscriptions as activeSubscriptionCount' => function ($query) {
                $query->where('status', 'active');
            },
            'subscriptions as inactiveSubscriptionCount' => function ($query) {
                $query->where('status', '!=', 'active');
            },
            'payments as unpaidPaymentCount' => function ($query) {
                $query->where('status', 'unpaid');
            },
            'payments as paidPaymentCount' => function ($query) {
                $query->where('status', 'paid');
            },
        ]);

        $firstUnpaidPayment = $user->payments()->where('status', 'unpaid')->first();
     

        return view('dashboard', compact('firstUnpaidPayment', 'user'));
    }
}
