<?php

namespace App\Http\Controllers;

abstract class Controller
{

    public function redirectError($url, $message = 'Something went wrong')
    {
        return redirect($url)->with('flash', ['type' => 'error', 'message' => $message]);
    }

    public function redirectSuccess($url, $message = 'Aksi berhasil dilakukan')
    {
        return redirect($url)->with('flash', ['type' => 'success', 'message' => $message]);
    }

    public function backSuccess($message = 'Aksi berhasil dilakukan')
    {
        return redirect()->back()->with('flash', ['type' => 'success', 'message' => $message]);
    }

    public function backError($message = 'Something went wrong')
    {
        return redirect()->back()->with('flash', ['type' => 'error', 'message' => $message]);
    }
}
