<?php

namespace App\Http\Controllers;

use App\Models\Payment;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class CallbackPaymentController extends Controller
{
    public function index(Request $request)
    {
        $apiKey = env('DUITKU_APIKEY'); // API key anda

        $merchantCode = $request->input('merchantCode');
        $amount = $request->input('amount');
        $merchantOrderId = $request->input('merchantOrderId');
        $signature = $request->input('signature');
        $resultCode
            = $request->input('resultCode');


        // Validate the required parameters
        if (!empty($merchantCode) && !empty($amount) && !empty($merchantOrderId) && !empty($signature)) {
            $params = $merchantCode . $amount . $merchantOrderId . $apiKey;
            $calcSignature = md5($params);

            if ($signature === $calcSignature) {
                $payment = Payment::where('invoice_number', $merchantOrderId)->first();

                $payment->update([
                    'status' => $resultCode == 00 ? 'paid' : 'unpaid',
                ]);

                return response()->json(['message' => 'Callback validated successfully']);
            } else {
                throw new Exception('Bad Signature');
            }
        } else {
            throw new Exception('Bad Parameter');
        }
    }

    public function callbackIpaymu(Request $request){

        $refid = $request->input('reference_id') ?? null;
        $status = $request->input('status') ?? null;

        if ($status && $refid) {
            $s = [
                'expired' => 'canceled',
                'pending' => 'pending',
                'success' => 'paid',
                'berhasil' => 'paid',
            ];

            if (isset($s[$status])) {
                $realStatus = $s[$status];
                $payment = Payment::where('invoice_number', $refid)->first();

                if ($payment && $payment->status === 'unpaid') {
                    // update hanya kalau statusnya masih 'unpaid'
                    $payment->update(['status' => $realStatus]);
                }
            }
        }
    }
}
