<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class AppUpdateController extends Controller
{
    protected $apps = [
        'sb' => ['version' => '3.8.0', 'file' => 'sb.zip'],
        'dialogflow' => ['version' => '1.5.1', 'file' => 'dialogflow.zip'],
        'waunofficial' => ['version' => '1.5.6', 'file' => 'wa156.zip'],
        'whatsapp' => ['version' => '1.2.9', 'file' => 'waofficial.zip'],
        'messenger' => ['version' => '1.1.6', 'file' => 'messenger.zip'],
        'telegram' => ['version' => '1.0.6', 'file' => 'telegram.zip'],
    ];
    protected $allowedDomains = ['interaksi.live', 'wslacrm.com','localhost'];

    public function __construct()
    {
        $this->allowedDomains[] = env('APP_DOMAIN', 'defaultdomain.com');
        if (env('APP_ENV') !== 'production') {
            $this->allowedDomains[] = 'localhost';
        }
    }
    public function versions()
    {
        $versions = [];
        foreach ($this->apps as $key => $value) {
            $versions[$key] = $value['version'];
        }
        return response()->json($versions);
    }

    public function updates(Request $request)
    {
        $params = $request->query();
        $updates = [];

        abort_if(!isset($params['domain']), 403);
        $domain = parse_url($params['domain'], PHP_URL_HOST) ?? $params['domain'];
        $domainParts = explode('.', $domain);
        $baseDomain = implode('.', array_slice($domainParts, -2));
        abort_if(!in_array($baseDomain, $this->allowedDomains), 403);



        foreach ($params as $key => $value) {
            if ($value == 1 && isset($this->apps[$key])) {
                $updates[$key] = $this->apps[$key]['file'];
            }
        }

        return empty($updates) ? 'missing-arguments' : response()->json($updates);
    }


    public function getFile($filename, Request $request)
    {
        $params = $request->query();

        abort_if(!isset($params['domain']), 403);
        $domain = parse_url($params['domain'], PHP_URL_HOST) ?? $params['domain'];
        $domainParts = explode('.', $domain);
        $baseDomain = implode('.', array_slice($domainParts, -2));
        abort_if(!in_array($baseDomain, $this->allowedDomains), 403);

        $filePath = storage_path('app/private/' . $filename);


        if (!file_exists($filePath)) {
            return   null;
        }


        // Return file sebagai download response
        return response()->download($filePath, $filename, [
            'Content-Type' => 'application/zip',
            'Content-Length' => filesize($filePath)
        ])->setStatusCode(200);
    }
}
