<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Http;
use App\Models\SocialChannel;

class WebhookController extends Controller
{
    public function index(Request $request)
    {
        if ($request->isMethod('get')) {
            $verifyToken = '857909';

            $mode = $request->query('hub_mode');
            $token = $request->query('hub_verify_token');
            $challenge = $request->query('hub_challenge');

            if ($mode === 'subscribe' && $token === $verifyToken) {
                return response($challenge, 200);
            }

            return response('Unauthorized', 403);
        }

        $data = $request->all();
        Log::info('Webhook POST received: ' . json_encode($data));

        $objectType = data_get($data, 'object'); // 'instagram' atau 'page'
        $id = data_get($data, 'entry.0.id'); // ID yang dikirim

        if (!$id || !$objectType) {
            Log::warning('Missing object type or entry ID in webhook payload.');
            return response('Invalid webhook payload', 400);
        }

        $cacheKey = "webhook:{$objectType}:{$id}";

        $channelData = Cache::remember($cacheKey, now()->addMinutes(5), function () use ($objectType, $id) {
            if ($objectType === 'instagram') {
                return SocialChannel::with('subscription')
                    ->whereHas('subscription', function ($query) use ($id) {
                        $query->where('instagram_id', $id);
                    })->first();
            } elseif ($objectType === 'page') {
                return SocialChannel::with('subscription')
                    ->where('channel_id', $id)
                    ->first();
            } else {
                return null;
            }
        });

        if (!$channelData || !$channelData->subscription) {
            Log::warning("No SocialChannel/subscription found for {$objectType} ID: $id");
            return response('Channel/subscription not found', 404);
        }

        $subdomain = $channelData->subscription->domain;
        $protocol = env('APP_ENV') === 'local' ? 'http' : 'https';
        $url = "{$protocol}://{$subdomain}/apps/messenger/post.php";

        try {
            $response = Http::post($url, $data);
            Log::info("Forwarded webhook to {$url}, response: " . $response->body());
        } catch (\Exception $e) {
            Log::error("Failed to forward webhook: " . $e->getMessage());
            return response('Failed to forward', 500);
        }

        return response('EVENT_RECEIVED', 200);
    }
}
