<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\SocialChannel;
use App\Models\Subscription;
use App\Services\Apps\FacebookApp;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

use Illuminate\Http\RedirectResponse;


class AppAuthController extends Controller
{
    protected FacebookApp $fbApp;
    protected ?string $subdomain = null;
    protected ?string $app = null;
    protected $subscription;

    public function __construct(FacebookApp $fbApp)
    {
        $this->fbApp = $fbApp;
    }

    private function validateApp(Request $request): void
    {
        $subdomain = preg_replace('#^https?://#', '', $request->query('subdomain'));
        $subscription = Subscription::with('server')->where('domain', $subdomain)->where('status', 'active')->first();

        $this->subscription = $subscription;
        $app = $request->query('app');
        if (!$subdomain || !$app) {
            abort(401, 'No subdomain received or unknown app');
        }

        $this->subdomain = $subdomain;
        $this->app = $app;
    }



    public function loginApp(Request $request)
    {
        if (!env('FB_ACTIVE')) {
            return json_encode(['errors' => 'sorry, login automatic currently not available..please login manual']);
        }
        $this->validateApp($request);
        if (!$this->subscription) return json_encode(['errors' => 'no subscription']);
        $loginUrl = $this->fbApp->login($this->subdomain);
        return redirect()->away($loginUrl);
    }


    public function facebookCallback(Request $request)
    {
        $state = $request->query('state');
        abort_if(!$state, 400, 'Missing state parameter');

        $subscription = Subscription::with('server')->where('domain', $state)->where('status', 'active')->first();
        abort_if(!$subscription, 404, 'Subscription not found or inactive');

        $pages = $this->fbApp->callback($state, $subscription);


        return redirect()->away('https://' . $state . '/admin.php?setting=messenger');
    }


    public function unsubscribe(Request $request)
    {
        abort_if(!$request->pageId, 404);
        $page = SocialChannel::where('channel_id', $request->pageId)->where('channel_type', 'page')->first();
        abort_if(!$page, 404);
        $a = $this->fbApp->removePageFromApp($page->channel_id, $page->access_token, $page->instagram_id);
        dd($a);
    }
}
