<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class UserController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = User::withCount('subscriptions'); //
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('subscription_count', function ($row) {
                    return $row->subscriptions_count;
                })
                ->addColumn('action', function ($row) {

                    $btn = '<a href="javascript:void(0)"  data-id="' . $row->id . '"   class="delete ml-2 btn btn-danger btn-sm">Hapus</a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }


        return view('admin.users.index');
    }

    public function destroy(User $user)
    {
        $user->delete();
        return response()->json(['message' => 'User deleted successfully']);
    }
}
