<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Subscription;
use App\Models\User;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class SubscriptionController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = Subscription::with('user', 'lastPayment');
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('user', function ($row) {
                    return $row->user->name ?? 'N/A';
                })->addColumn('last_payment', function ($row) {
                    if (!$row->lastPayment) return 'N/A';
                    $url = route('invoices.detail', $row->lastPayment->invoice_number);
                    $btn = '<a href="' . $url . '">' . $row->lastPayment->invoice_number . '</a>';
                    return $btn;
                })

                ->addColumn('action', function ($row) {
                    $editUrl = route('admin.subscriptions.edit', $row->id);
                    $btn = '<a href="' . $editUrl . '" class="btn btn-primary btn-sm">Edit</a>';
                    $btn .= '<a href="javascript:void(0)" class="btn btn-danger btn-sm delete" data-url="' . route('admin.subscriptions.destroy', $row->id) . '">Delete</a>';
                    return $btn;
                })
                ->rawColumns(['action', 'last_payment'])
                ->make(true);
        }
        return view('admin.subscriptions.index');
    }

    public function edit($id)
    {
        $subscription = Subscription::findOrFail($id);
        $users = User::all();
        return view('admin.subscriptions.edit', compact('subscription', 'users'));
    }

    public function update(Request $request, $id)
    {

        $data = $request->validate([
            'user_id' => 'required|exists:users,id',
            'domain' => 'required|string',
            'product' => 'required|string',
            'status' => 'required|in:active,inactive,suspend,waiting,processing',
            'start_date' => 'nullable|date',
            'due_date' => 'nullable|date',
            'details' => 'nullable|string',
            'ns' => 'nullable|string',
        ]);

        $subscription = Subscription::findOrFail($id);
        $data['server_id'] = $subscription->server_id;
      //  $data['details'] = json_encode($data['details']);
        $subscription->update($data);

        return $this->redirectSuccess(route('admin.subscriptions.index'), 'Subscription updated successfully');
    }

    public function destroy($id)
    {
        Subscription::findOrFail($id)->delete();
        return json_encode(['success' => true]);
    }
}
