<?php

namespace App\Http\Controllers\Admin;
use App\Exports\MonthlyInvoiceExport;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Controllers\Controller;
use App\Models\Payment;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Yajra\DataTables\DataTables;

class InvoiceController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            if ($request->ajax()) {
                $data = Payment::with('user');
                return DataTables::of($data)
                    ->addIndexColumn()
                    ->addColumn('user', function ($row) {
                        return $row->user->name ?? 'N/A';
                    })->addColumn('created_at', function ($row) {
                        return $row->created_at->format('d M Y H:i');
                    })->addColumn('expired_at', function ($row) {
                        return Carbon::parse($row->expired_at)->format('d M Y H:i');
                    })->addColumn('payment_method', function ($row) {
                        $data = json_decode($row->payment_details);
                        return $data->type ?? 'N/A';
                    })
                    ->addColumn('action', function ($row) {
                        // URL untuk berbagai tindakan
                        $viewUrl = route('invoices.detail', $row->invoice_number);
                        $markAsPaidUrl = route('admin.invoices.mark-as-paid', $row->id);
                        $cancelUrl = route('admin.invoices.cancel', $row->id);

                        $btn = '<div class="btn-group" role="group">';
                        $btn .= '<a href="' . $viewUrl . '" class="btn btn-primary btn-sm">View</a>';
                        if ($row->status == 'unpaid') {
                            $btn .= '<a href="javascript:void(0)" class="btn btn-success btn-sm mark-as-paid" data-url="' . $markAsPaidUrl . '">Mark as Paid</a>';
                        $btn .= '<a href="javascript:void(0)" class="btn btn-danger btn-sm cancel" data-url="' . $cancelUrl . '">Cancel</a>';
                        }


                        $btn .= '</div>';

                        return $btn;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
            }
        }
        return view('admin.invoices.index');
    }


    public function markAsPaid(Payment $invoice)
    {
        $invoice->update(['status' => 'paid', 'payment_details' => $invoice->payment_details ?? json_encode(['type' => 'manual'])]);
      //its trigger the observer
        // $subscription = $invoice->subscription;
        // $subscription->update(
        //     [
        //         'status' => 'active',
        //         'start_date' => now(),

        //     ]
        // );
        return json_encode(['success' => true]);
    }

    public function cancel(Payment $invoice)
    {
        $invoice->update(['status' => 'canceled', 'payment_details' => $invoice->payment_details ?? json_encode(['type' => 'manual'])]);
        $subscription = $invoice->subscription;
        $subscription->update(
            [
                'status' => 'inactive',
            ]
        );
        return json_encode(['success' => true]);
    }




public function export(Request $request)
{
    $month = $request->get('month');
    return Excel::download(new MonthlyInvoiceExport($month), 'invoice_bulan_' . $month . '.xlsx');
}

}
