<?php

namespace App\Http\Controllers\Admin;

use App\Clients\CloudflareApi;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Yajra\DataTables\Facades\DataTables;

class DomainController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $cloudflare = new CloudflareApi();

            // Ambil parameter pagination dari request DataTables
            $start = $request->input('start', 0); // offset
            $length = $request->input('length', 10); // per page
            $page = intval($start / $length) + 1;

            $result = $cloudflare->getSubdomains($page, $length);

            if (!$result['success']) {
                return response()->json([
                    'data' => [],
                    'recordsTotal' => 0,
                    'recordsFiltered' => 0,
                    'error' => $result['message']
                ]);
            }

            $subdomains = $result['subdomains'];
            $total = $result['total'];

            return DataTables::of($subdomains)
                ->addIndexColumn()
                ->addColumn('name', function ($row) {
                    return $row['name'];
                })
                ->addColumn('type', function ($row) {
                    return $row['type'];
                })
                ->addColumn('content', function ($row) {
                    return $row['content'];
                })
                ->addColumn('created_on', function ($row) {
                    return isset($row['created_on'])
                        ? \Carbon\Carbon::parse($row['created_on'])->format('d M Y H:i')
                        : '-';
                })
                ->addColumn('action', function ($row) {
                    $deleteUrl = route('admin.domains.delete', ['name' => $row['name']]);
                    return '<a href="javascript:void(0)" class="btn btn-danger btn-sm delete-domain" data-url="' . $deleteUrl . '">Delete</a>';
                })
                ->rawColumns(['action'])
                ->setTotalRecords($total)
                ->setFilteredRecords($total)
                ->skipPaging() // kita handle paging manual di atas
                ->make(true);
        }

        return view('admin.servers.domain');
    }


    public function delete(Request $request)
    {
        try {
            $name = $request->name;
            $cloudflare = new CloudflareApi();
            $cloudflare->deleteSubdomain($name);
            return response()->json(['message' => 'subdomain deleted successfully.']);
        } catch (\Throwable $th) {
            //throw $th;
        }
    }
}
