<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Payment;
use App\Models\Subscription;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $activeSubscriptionCount = Subscription::where('status', 'active')->count();
        $inactiveSubscriptionCount = Subscription::where('status', '!=', 'active')->count();

        $unpaidPaymentCount = Payment::where('status', 'unpaid')->count();
        $paidPaymentCount = Payment::where('status', 'paid')->count();

        $firstUnpaidPayment = Payment::where('status', 'unpaid')->orderBy('created_at', 'asc')->first();
        $monthlyPaid = DB::table('payments')
        ->selectRaw('MONTH(created_at) as month, SUM(amount) as total')
        ->where('status', 'paid')
        ->whereYear('created_at', now()->year)
        ->groupByRaw('MONTH(created_at)')
        ->pluck('total', 'month'); // hasil: [1 => "340000"]

    $paidData = [];
    for ($i = 1; $i <= 12; $i++) {
        $paidData[] = (int) $monthlyPaid->get($i, 0); // cast ke int, hasil: [340000, 0, 0, ..., 0]
    }
        return view('admin.dashboard', compact(
            'activeSubscriptionCount',
            'inactiveSubscriptionCount',
            'unpaidPaymentCount',
            'paidPaymentCount',
            'firstUnpaidPayment',
               'paidData'
        ));
        // return view('admin.dashboard', compact(
        //     'activeSubscriptionCount',
        //     'inactiveSubscriptionCount',
        //     'unpaidPaymentCount',
        //     'paidPaymentCount',
        //     'firstUnpaidPayment',

        // ));
    }
}
