<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AccountController extends Controller
{
    public function settings(Request $request)
    {
        $user = $request->user();
        return view('account.settings', compact('user'));
    }

    public function updateSettings(Request $request)
    {
        $request->validate([
            'whatsapp' => 'nullable|string|max:15', // Ganti sesuai kebutuhan validasi
            'name' => 'required|string|max:255',
            'new_password' => 'nullable|string|min:8|confirmed', // Validasi jika kata sandi baru diisi
            'password' => 'required|string', // Validasi kata sandi lama
        ]);

        $user = $request->user();

        if (!Hash::check($request->password, $user->password)) {
            return $this->backError('Password lama tidak sesuai');
        }

        $user->whatsapp = $request->whatsapp;
        $user->name = $request->name;
        if ($request->new_password) {
            $user->password = Hash::make($request->new_password);
        }
        $user->save();
        return $this->backSuccess('Berhasil memperbarui pengaturan akun');
    }
}
