<?php

namespace App\Exports;



use App\Models\Payment;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class MonthlyInvoiceExport implements FromView
{
    protected $month;

    public function __construct($month)
    {
        $this->month = $month;
    }

    public function view(): View
    {
        return view('exports.monthly_invoices', [
            'invoices' => Payment::whereMonth('created_at', $this->month)
                ->whereYear('created_at', now()->year)

                ->with('user') // jika kamu butuh relasi
                ->get()
        ]);
    }
}
