<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class SubscriptionEnd extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:subscription-end';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $subs = \App\Models\Subscription::where('status', 'active')
            ->where('due_date', '<=', now())
            ->get();

        foreach ($subs as $sub) {
            $sub->status = 'inactive';
            $sub->save();
        }

        $this->info('Subscriptions ended');
    }
}
