<?php

namespace App\Console\Commands;

use App\Models\Subscription;
use Illuminate\Console\Command;

class GenerateInvoices extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'generate:invoices';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $subscriptions = Subscription::where('status', 'active')->where('price', '>', 0)
            ->where('due_date', '<=', now()->addDays(3))
            ->get();

        foreach ($subscriptions as $subscription) {
            // Cek jika sudah ada invoice dalam 3 hari sebelumnya
            $existingInvoice = $subscription->payments()->where('created_at', '>=', now()->subDays(3))->exists();

            if (!$existingInvoice) {
                // Jika belum ada invoice, buat invoice baru
                $subscription->payments()->create([
                    'invoice_number' => 'INV' . time() . '' . $subscription->user_id,
                    'user_id' => $subscription->user_id,
                    'amount' => $subscription->price,
                    'status' => 'unpaid',
                    'expired_at' => now()->addDays(5),
                    'description' => "Tagihan untuk langganan " . $subscription->product . " " . $subscription->package . " " . ($subscription->domain) . " Periode " . $subscription->due_date,
                    'payment_type' => 'renewal',
                ]);
            }
        }
    }
}
