<?php


namespace App\Clients;


use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class WaNotifClient
{


    protected  $to;

    protected  $lines;


    protected  $apikey;
    protected  $url;
    protected  $sender;

    protected $image = null;


    /**
     * SmsMessage constructor.
     * @param array $lines
     */
    public function __construct($lines = [])
    {
        $this->lines = $lines;


        $this->apikey = env('WAMP_API_KEY');
        $this->url = env('WAMP_URL');
        $this->sender = env('WAMP_SENDER');
        Log::info(env('WAMP_URL'));
    }

    public function image($image): self
    {
        $this->image = $image;

        return $this;
    }

    public function line($line = ''): self
    {
        $this->lines[] = $line;

        return $this;
    }

    public function bold($text): self
    {
        // add text to last line
        if (!empty($this->lines)) {
            $this->lines[count($this->lines) - 1] .= "*{$text}*";
        } else {
            $this->lines[] = " *{$text}*";
        }
        return $this;
    }

    public function italic($text): self
    {
        // add text to last line
        if (!empty($this->lines)) {
            $this->lines[count($this->lines) - 1] .= "_{$text}_";
        } else {
            $this->lines[] = "_{$text}_";
        }
        return $this;
    }

    public function mono($text): self
    {
        // add text to last line
        if (!empty($this->lines)) {
            $this->lines[count($this->lines) - 1] .= "```{$text}```";
        } else {
            $this->lines[] = " ```{$text}```";
        }
        return $this;
    }

    public function code($text): self
    {
        // add text to last line
        if (!empty($this->lines)) {
            $this->lines[count($this->lines) - 1] .= "`{$text}`";
        } else {
            $this->lines[] = " `{$text}`";
        }
        return $this;
    }

    public function continue($text): self
    {
        // add text to last line
        if (!empty($this->lines)) {
            $this->lines[count($this->lines) - 1] .= " {$text}";
        } else {
            $this->lines[] = " {$text}";
        }
        return $this;
    }


    public function separator(): self
    {
        // add text to last line
        $this->lines[] = str_repeat('-', 35);
        return $this;
    }

    public function to($to): self
    {
        $this->to = $to;

        return $this;
    }



    public function send()
    {
        if (!$this->to || !count($this->lines)) {
            return false;
        }



        try {
            $route = $this->image ? '/send-media' : '/send-message';
            $send =  Http::withOptions(['verify' => false])->post($this->url . $route, [
                'api_key' => $this->apikey,
                'sender' => $this->sender,
                'number' => $this->to,
                'message' => join("\n", $this->lines),
                //if image is set, send image
                'url' => $this->image,
                'media_type' => 'png',
                'caption' => join("\n", $this->lines),

            ]);
            return $send->body();
        } catch (\Throwable $th) {

            return false;
        }
    }
}
