<?php

namespace App\Clients;


use Illuminate\Support\Facades\Http;


class IpaymuService
{
    protected $baseUrl = 'https://my.ipaymu.com/api/v2/'; // Replace with your actual API URL
    public $apiKey; // Replace with your actual API key
    public $va;





    public function __construct()
    {

        $this->apiKey = env('IPAYMU_KEY');
        $this->va = env('IPAYMU_VA');

    }

    public function createTransaction($user,$refId, $method, $amount,$desc = "")
    {
        $data = [];
        $data['name'] = $user->name;
        $data['phone'] = $user->whatsapp;
        $data['email'] = $user->email;
        $data['amount'] = $amount;
        $data['referenceId'] = $refId;
        $data['paymentMethod'] = strtolower($method->type);
        $data['paymentChannel'] = $method->code;
       $data['comments'] = $desc;
        $data['notifyUrl'] = route('callback_ipaymu');

        $jsonBody = json_encode($data, JSON_UNESCAPED_SLASHES);
        $requestBody = strtolower(hash('sha256', $jsonBody));
        $stringToSign = strtoupper('POST') . ':' . $this->va . ':' . $requestBody . ':' . $this->apiKey;
        $signature = hash_hmac('sha256', $stringToSign, $this->apiKey);
        $timestamp = Date('YmdHis');

        $response = Http::withHeaders([
            'Accept' => 'application/json',
            'Content-Type' => 'application/json',
            'va' => $this->va,
            'signature' => $signature,
            'timestamp' => $timestamp,
        ])->post($this->baseUrl . 'payment/direct', $data);

        return $response->json();

    }


    public function checkTransactionStatus($unique_code)
    {
        $data = [
            'key' => $this->apiKey,
            'request' => 'status',
            'unique_code' => $unique_code,
            'signature' => md5($this->apiKey . $unique_code . 'StatusTransaction'),
        ];

        $response = Http::asForm()->post($this->baseUrl, $data);

        return $response->json();
    }

    public function viewPaymentChannels()
    {

        $requestBody  = strtolower(hash('sha256', '{}'));
        $stringToSign = "GET:{$this->va}:{$requestBody}:{$this->apiKey}";
        $timestamp    = Date('YmdHis');
        $signature = hash_hmac('sha256', $stringToSign, $this->apiKey);
        $response = Http::withHeaders([
            'Accept'        => 'application/json',
            'Content-Type'  => 'application/json',
            'va'            => $this->va,
            'signature'     => $signature,
            'timestamp'     => $timestamp
        ])->get($this->baseUrl . "payment-channels");



        return $response->json();
    }
}
