<?php

namespace App\Clients;

use Illuminate\Support\Facades\Http;

class DuitkuClient
{

    protected $apiKey;
    protected $baseUrlSandbox =  'https://api-prod.duitku.com/api/';
    protected $merchantCode;

    public function __construct()
    {
        $this->apiKey = env('DUITKU_APIKEY');
        $this->merchantCode  = env('DUITKU_MERCHANT_CODE');
    }

    public function createTransaction($refid, $amount, $note, $customerEmail)
    {

        $ts =    round(microtime(true) * 1000);
        $headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/json',
            'x-duitku-signature' => $this->createSignature($ts),
            'x-duitku-timestamp' => $ts,
            'x-duitku-merchantcode' => $this->merchantCode
        ];

        $body = [
            'paymentAmount' => $amount,
            'merchantOrderId' => $refid,
            'productDetails' => $note,
            'email' => $customerEmail,
            'callbackUrl' => route('callback_pg'),
            'returnUrl' => route('invoices.detail', $refid)

        ];

        $response = Http::withHeaders($headers)->post($this->baseUrlSandbox . "merchant/createInvoice", $body);

        $responseData = $response->json(); // Mengurai JSON ke array
        return $responseData;
    }

    protected function createSignature($ts)
    {

        return hash('sha256', $this->merchantCode .  $ts  . $this->apiKey);
    }
}
