<?php

namespace App\Clients;

use App\Models\Server;
use Illuminate\Support\Facades\Log;
use phpseclib3\Crypt\PublicKeyLoader;
use phpseclib3\Net\SSH2;

class ConfigWebsiteSsh
{
    private $conn;
    private $filePath = '/home/interaksilive.zip';
    private $webDir = '/www/wwwroot/';

    private $domain;
    private $server;

    private $details = [];
    private $logs = [];

    public function __construct(Server $server)
    {
        $this->server = $server;
    }



    public function connect()
    {
        try {
            $key = PublicKeyLoader::load($this->server->sshkey);
            $ssh = new SSH2($this->server->host, $this->server->port);
            if (!$ssh->login($this->server->username, $key)) {
                throw new \Exception('SSH Login Failed');
            }
            $this->conn = $ssh;
            return $this;
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            throw new \Exception("Error in connect(): " . $th->getMessage());
        }
    }

    public function uploadAndExtractFile($domain)
    {
        //copy file
        $this->conn->exec("sudo cp $this->filePath {$this->webDir}{$domain}/interaksilive.zip");
        //unzip file
        $this->conn->exec("sudo unzip {$this->webDir}{$domain}/interaksilive.zip -d {$this->webDir}{$domain}");

        //set permission
        $this->conn->exec("sudo find {$this->webDir}{$domain} -type f ! -name '.user.ini' ! -name '.htaccess' -exec chown www:www {} +");
        $this->conn->exec("sudo find {$this->webDir}{$domain} -type d -exec chown www:www {} +");


        $this->domain = $domain;
        return $this;
    }





    public function config($dbuser, $dbpass, $dbname, $user, $ssl)
    {

        $email = $user->email;
        $password = $this->generateRandomString(10);
        //
        $prefix = $ssl ? 'https://' : 'http://';
        $url = $prefix . $this->domain;
        $installTemplatePath = "{$this->webDir}{$this->domain}/resources/install-source.php";
        $remoteInstallPath = "{$this->webDir}{$this->domain}/install.php";
        $installTemplate = $this->conn->exec("cat " . escapeshellarg($installTemplatePath));
        $installContent = str_replace(
            ['[dbname]', '[dbuser]', '[dbpass]', '[dbhost]', '[dbport]', '[url]', '[name]', '[email]', '[password]'],
            [
                $dbname,
                $dbuser,
                $dbpass,
                "localhost",
                "3306",
                $url,
                $user->name,
                $email,
                $password
            ],
            $installTemplate
        );

        $createInstall = $this->conn->exec("echo " . escapeshellarg($installContent) . " | sudo tee " . escapeshellarg($remoteInstallPath));


        $curladmin = $this->conn->exec("curl -s {$url}/admin.php > /dev/null");

        sleep(5);
        $curlinstall = $this->conn->exec("curl -s {$url}/install.php > /dev/null");

        //remove install.php
        $removeinstallfile =  $this->conn->exec("sudo rm -f {$this->webDir}{$this->domain}/install.php");

        $this->disconnect();
        return [
            'email' => $user->email,
            'password' => $password,
            'url' => 'https://' . $this->domain,
            'server' => $this->server->host,

        ];
    }



    public function disconnect()
    {
        $this->conn->disconnect();
    }


    public function getServerStats()
    {
        try {
            $cpuLoad = $this->conn->exec("top -bn1 | grep 'Cpu(s)'");
            $memory = $this->conn->exec("free -m");
            $uptime = $this->conn->exec("uptime -p");
            $disk = $this->conn->exec("df -h /");

            return [
                'cpu' => trim($cpuLoad),
                'memory' => trim($memory),
                'uptime' => trim($uptime),
                'disk' => trim($disk),
            ];
        } catch (\Throwable $th) {
            Log::error("Error in getServerStats(): " . $th->getMessage());
            return [
                'error' => 'Failed to retrieve server stats.'
            ];
        }
    }




    private function generateRandomString($length = 10)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}
