<?php sejoli_header('login'); ?>

<div class="ui stackable centered grid">
    <div class="five wide column center aligned">
        <div class="ui image">
            <img src="<?php echo sejolisa_logo_url(); ?>" class="image icon">
        </div>
        <?php sejoli_get_template_part('messages.php'); ?>
        <form class="ui large form" method="POST" action="<?php echo sejoli_get_endpoint_url('register'); ?>">

            <div class="ui stacked segment">
                 <?php
                    $display_username = boolval(sejolisa_carbon_get_theme_option('sejoli_registration_display_username'));
                    if(true === $display_username) :
                ?>
                    <div class="required field">
                        <div class="ui left icon input">
                            <i class="user icon"></i>
                            <input type="text" name="user_login" placeholder="Nama Pengguna" value="<?php echo isset($_POST['user_login']) ? $_POST['user_login'] : ''; ?>">
                        </div>
                    </div>
                <?php endif; ?>
                <div class="required field">
                    <div class="ui left icon input">
                        <i class="user icon"></i>
                        <input type="text" name="full_name" placeholder="Nama Lengkap" value="<?php echo isset($_POST['full_name']) ? $_POST['full_name'] : ''; ?>">
                    </div>
                </div>
                <div class="required field">
                    <div class="ui left icon input">
                        <i class="envelope icon"></i>
                        <input type="email" name="email" placeholder="Alamat Email" value="<?php echo isset($_POST['email']) ? $_POST['email'] : ''; ?>">
                    </div>
                </div>
                <?php
                    $display_password = boolval(sejolisa_carbon_get_theme_option('sejoli_registration_display_password'));
                    if(true === $display_password) :
                ?>
                    <div class="required field">
                        <div class="ui left icon input">
                            <i class="lock icon"></i>
                            <input type="password" name="password" placeholder="Passwords" autocomplete="false">
                        </div>
                    </div>
                    <div class="required field">
                        <div class="ui left icon input">
                            <i class="lock icon"></i>
                            <input type="password" name="confirm_password" placeholder="Konfirmasi Password"  autocomplete="false">
                        </div>
                    </div>
                <?php endif; ?>
                <div class="required field">
                    <div class="ui left icon input">
                        <i class="whatsapp icon"></i>
                        <input type="number" name="wa_phone" placeholder="Nomor WhatsApp" value="<?php echo isset($_POST['wa_phone']) ? $_POST['wa_phone'] : ''; ?>">
                    </div>
                </div>
                <?php
                    $g_recaptcha_enable   = boolval( sejolisa_carbon_get_theme_option( 'sejoli_google_recaptcha_enabled' ) );
                    $g_recaptcha_register = boolval( sejolisa_carbon_get_theme_option( 'sejoli_google_recaptcha_register_page' ) );

                    if( true === $g_recaptcha_enable && true === $g_recaptcha_register ) :
                ?>
                    <div class="g-recaptcha-area">
                        <input type="hidden" name="recaptcha_response" id="recaptchaResponse">
                    </div>
                <?php endif; ?>
                <button type='submit' class="ui fluid large teal submit button">
                    Register
                </button>
            </div>
            <?php wp_nonce_field('user-register','sejoli-nonce'); ?>
        </form>

        <div class="ui message">
            Sudah punya akun? <a href="<?php echo sejoli_get_endpoint_url('login'); ?>">Login</a>
        </div>
    </div>
</div>

<?php
$g_recaptcha          = boolval(sejolisa_carbon_get_theme_option( 'sejoli_google_recaptcha_enabled' ));
$g_recaptcha_register = boolval( sejolisa_carbon_get_theme_option( 'sejoli_google_recaptcha_register_page' ) );
$g_recaptcha_sitekey  = esc_attr(sejolisa_carbon_get_theme_option( 'sejoli_google_recaptcha_sitekey' ));
if( true === $g_recaptcha && true === $g_recaptcha_register && !empty($g_recaptcha_sitekey) ) :
?>
<script>
    jQuery(document).ready(function($){
        
        grecaptcha.ready(() => {
            grecaptcha.execute('<?php echo $g_recaptcha_sitekey ?>', { action: 'checkout' }).then(token => {
                document.querySelector('#recaptchaResponse').value = token;
            });
        });

    });
</script>
<?php endif; ?>

<?php sejoli_footer('login'); ?>
