<?php

namespace SejoliSA\Front;

use Carbon_Fields\Container;
use Carbon_Fields\Field;

class Facebook_Tiktok_Conversion {

    /**
	 * The ID of this plugin.
	 *
	 * @since    1.3.2
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.3.2
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

    /**
	 * Initialize the class and set its properties.
	 *
	 * @since   1.3.2
	 * @param   string    $plugin_name      The name of the plugin.
	 * @param   string    $version    		The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version     = $version;

	}

    /**
     * Set facebook pixel in local data
     * Hooked via action wp_enqueue_scripts, priority 888
     * @since   1.3.2
     * @since 	1.5.1.1 	Remove content_type and content_category
     * @return  void
     */
    public function set_localize_js_vars() {

    	if( sejolisa_is_member_area_page('akses') )  :

	        wp_localize_script( 'sejoli-member-area', 'sejoli_fb_tiktok_conversion', [
	            'fb_tiktok_access_pixel_conversion' => [
					'ajaxurl' => add_query_arg([
						'action' => 'sejoli-fb-tiktok-access-pixel-conversion',
					], admin_url('admin-ajax.php')),
					'nonce'	=> wp_create_nonce('sejoli-fb-tiktok-access-pixel-conversion')
				],
	        ]);

	    endif;

    }

    /**
     * Get user bonus content from affiliate
     * Hooked via wp_ajax_sejoli-fb-tiktok-access-pixel-conversion, priority 1
     * @since   1.0,0
     * @return  json
     */
    public function fb_tiktok_click_access_pixel_conversion() {

        $post_data = wp_parse_args($_GET,[
            'nonce'       => NULL,
            'product'     => NULL,
            'access_link' => NULL,
            'access'      => NULL,
        ]);

        if( wp_verify_nonce($post_data['nonce'], 'sejoli-fb-tiktok-access-pixel-conversion') && !empty($post_data['product']) && !empty($post_data['access_link']) && !empty($post_data['access']) ) :

            $user_id    = get_current_user_id();
        	$meta_value = "access-".$post_data['access'];
		    $get_value  = get_user_meta( $user_id, 'fb_tiktok_user_click_access_tracks', true );

		    if( !empty( $get_value ) ) :
			    
			    if ( ! array($get_value) ) {
			        $get_value = array();
			    }

			    if( !in_array( $meta_value, $get_value ) ) :

			    	$get_value[] = $meta_value;

			    	update_user_meta( $user_id, 'fb_tiktok_user_click_access_tracks', $get_value );

			    	$fb_conversion_active = boolval(sejolisa_carbon_get_post_meta($post_data['product'], 'fb_conversion_active'));
		            $fb_eventString       = esc_attr(sejolisa_carbon_get_post_meta($post_data['product'], 'fb_conversion_event_click_link_access_page'));
		            if( true === $fb_conversion_active && !empty( $fb_eventString ) ) :
		            	sejoli_facebook_tracker( $post_data['product'], $fb_eventString );
		            endif;

		            $tiktok_conversion_active = boolval(sejolisa_carbon_get_post_meta($post_data['product'], 'tiktok_conversion_active'));
		            $tiktok_eventString       = esc_attr(sejolisa_carbon_get_post_meta($post_data['product'], 'tiktok_conversion_event_click_link_access_page'));
		            if( true === $tiktok_conversion_active && !empty( $tiktok_eventString ) ) :
		            	sejoli_tiktok_tracker( $post_data['product'], $tiktok_eventString );
		            endif;

	        	endif;

	        else:

			    $get_value   = array();
	        	$get_value[] = $meta_value;

		    	update_user_meta( $user_id, 'fb_tiktok_user_click_access_tracks', $get_value );

		    	$fb_conversion_active = boolval(sejolisa_carbon_get_post_meta($post_data['product'], 'fb_conversion_active'));
	            $fb_eventString       = esc_attr(sejolisa_carbon_get_post_meta($post_data['product'], 'fb_conversion_event_click_link_access_page'));
	            if( true === $fb_conversion_active && !empty( $fb_eventString ) ) :
	            	sejoli_facebook_tracker( $post_data['product'], $fb_eventString );
	            endif;

	            $tiktok_conversion_active = boolval(sejolisa_carbon_get_post_meta($post_data['product'], 'tiktok_conversion_active'));
	            $tiktok_eventString       = esc_attr(sejolisa_carbon_get_post_meta($post_data['product'], 'tiktok_conversion_event_click_link_access_page'));
	            if( true === $tiktok_conversion_active && !empty( $tiktok_eventString ) ) :
	            	sejoli_tiktok_tracker( $post_data['product'], $tiktok_eventString );
	            endif;

	       	endif;

        endif;

        return;
        
    }

}
