<?php

namespace SejoliSA\NotificationMedia;

use Carbon_Fields\Container;
use Carbon_Fields\Field;

class WooWandroidv2 extends WhatsApp {
    /**
     * Construction
     * @since   1.5.3.1
     */
    public function __construct() {
        add_filter('sejoli/whatsapp/setup-fields', [$this, 'setup_fields'], 1);
    }

    /**
     * Get name of service
     * @since   1.5.3.1
     * @return  string
     */
    public function get_label() {
        return 'woowandroidv2';
    }

    /**
     * Add setup fields to whatsapp fields
     * Hooked via filter sejoli/whatsapp/setup-fields, priority 1
     * @since   1.5.3.1
     * @param   array  $fields
     * @return  array
     */
    public function setup_fields(array $fields) {

        $setup_fields = [
            Field::make('textarea', 'woowandroidv2_cs_id',  __('CS ID', 'sejoli'))
                ->set_required(true)
                ->set_conditional_logic([
                    [
                        'field' => 'notification_whatsapp_service',
                        'value' => 'woowandroidv2'
                    ]
                ]),

            Field::make('select', 'woowandroidv2_whatsapp_type', __('Tipe akun WhatsApp', 'sejoli'))
                ->add_options(array(
                    'personal'  => __('Personal', 'sejoli'),
                    'bisnis'    => __('Bisnis', 'sejoli')
                ))
                ->set_conditional_logic([
                    [
                        'field' => 'notification_whatsapp_service',
                        'value' => 'woowandroidv2'
                    ]
                ])
        ];

        return array_merge($fields, $setup_fields);
    }

    /**
     * Send content
     * @since   1.5.3.1
     * @param   array  $recipients
     * @param   string $content
     * @param   string $title
     * @return  void
     */
    public function send(array $recipients, $content, $title = '', $recipient_type = 'buyer') {

        $cs_id         = trim(sejolisa_carbon_get_theme_option('woowandroidv2_cs_id'));
        $whatsapp_type = sejolisa_carbon_get_theme_option('woowandroidv2_whatsapp_type');

        foreach($recipients as $recipient) :

            $phone_number = str_replace('+', '+', apply_filters('sejoli/user/phone', $recipient));

            if(empty($phone_number)) :
                continue;
            endif;

            $post_data = array(
                'to'   => $cs_id,
                'data' => array(
                    'message'  => $content,
                    'number'   => $phone_number,
                    'whatsapp' => $whatsapp_type
                )
            );

            $json_data = json_encode($post_data, 1);

            $response = wp_remote_post('https://fcm.googleapis.com/fcm/send',[
                'headers'   => array(
                    'Content-Type'  => 'application/json',
                    'Authorization' => 'Bearer AIzaSyCyXH1aC4rWgMQhaJuQLUTDXfWRBgrCZF4'
                ),
                'body' => $json_data
            ]);

            do_action(
                'sejoli/log/write',
                'response woowav2',
                array(
                    'post_data' => $post_data,
                    'response'  => (array) wp_remote_retrieve_body($response)
                )
            );

            sleep ( 2 );

        endforeach;
    }
}
