<?php




$raw = file_get_contents('php://input');
flush();
if (function_exists('fastcgi_finish_request')) {
    fastcgi_finish_request();
}
if ($raw) {
    require('../../include/functions.php');
    $response = json_decode($raw, true);
    $headers = getallheaders();


    //basic data
    $device = null;
    $message = null;
    $sender = $response['from'];
    $name = $response['name'];
    $ppUrl = $response['ppUrl'];
    $platform_code = 'waunofficial';
    $attachments = [];
    $type = false;
    $pathTemp = null; //for ;emporary upload file become be url,if mpwa,to deleted later


    // detect device/ account wa
    if (isset($headers['Resource-Owner'])) { // this detected as boostifyHub
        $type = 'boostifyhub';
        $device = str_replace('@s.whatsapp.net', '', $headers['Resource-Owner']); // from boostifyhub.id
        $message = $response['text'];
        if (is_array($response['media'])) {
            $attachments[] = $response['media'];
        }
    } else if (isset($response['device'])) { // this from mpwa
        $type = 'mpwa';
        $device = $response['device'];
        $message = $response['message'];

        if ($response['media'] !== null) {

            $media = $response['media'];
            $message = $media['caption'];
            $streamData = $media['stream']['data'];
            $binaryData = pack('C*', ...$streamData);
            $fileName = $media['fileName'];
            $fileName = str_replace(['_', '-'], '', $fileName);

            // Pastikan ekstensi tetap dipertahankan
            $extension = pathinfo($fileName, PATHINFO_EXTENSION);
            $lastFileName = rand(0000000, 9999999) . date('hi') . '.' . $extension;

            $tempPath = 'temp-uploads/' . $lastFileName;
            file_put_contents($tempPath, $binaryData);
            $urlTemp = SB_URL . "/apps/waunofficial/" . $tempPath;

            $pathTemp = $tempPath;
            $attachments[] = ['url' => $urlTemp, 'filename' => $lastFileName];





            // file_put_contents($tempPath, $stream['stream']);
        }
    }


    $user = false;

    $page_settings = sb_waunofficial_get_device($device);

    if (!$page_settings) {

        die();
    }

    // User
    $user = sb_db_get('SELECT A.id, A.first_name, A.last_name, A.profile_image, A.email, A.user_type FROM sb_users A, sb_users_data B WHERE A.user_type <> "agent" AND A.user_type <> "admin" AND A.id = B.user_id AND B.slug = "phone" AND B.value = "' . sb_db_escape($sender) . '" LIMIT 1');

    if (!$user) {
        $userDetails = ['first_name' => $name, 'profile_image' => sb_is_error($ppUrl) || empty($ppUrl) ? '' : $ppUrl, 'user_type' => 'lead'];
        $extra = ['phone' => [$sender, 'Phone']];


        $user_id = sb_add_user($userDetails, $extra);
        $user = sb_get_user($user_id);
    } else {
        $user_id = $user['id'];
    }

    if ($user_id) {
        //         // Get user and conversation information
        $GLOBALS['SB_LOGIN'] = $user;
        $conversation = sb_db_get('SELECT id, status_code FROM sb_conversations WHERE source = "' . $platform_code . '" AND user_id = ' . $user_id . ' AND extra = "' . $device . '" AND extra_2 = "' . $type . '" LIMIT 1');

        $conversation_id = sb_isset($conversation, 'id');
        $department = sb_isset($page_settings, 'waunofficial-department', -1);
        $count_attachments = count($attachments);


        if (!$conversation_id) {
            $conversation_id = sb_isset(sb_new_conversation($user_id, 2, '', $department, -1, $platform_code, $device, $type, sb_isset($page_settings, 'waunofficial-tags')), 'details', [])['id'];
        }

        // if ($count_attachments) {
        //     $previous_message = sb_db_get('SELECT attachments, creation_time FROM sb_messages WHERE conversation_id = ' . $conversation_id . ' ORDER BY id DESC LIMIT 1');
        //     $previous_message_count = count(json_decode($previous_message['attachments'], true));
        //     if ($previous_message && ($count_attachments === $previous_message_count || $previous_message_count > 1) && sb_get_timestamp($previous_message['creation_time']) > (time() - 60)) {
        //         $GLOBALS['SB_FORCE_ADMIN'] = false;
        //         return false;
        //     }
        // }

    }

    // Attachments
    $attachments_2 = [];

    for ($i = 0; $i < $count_attachments; $i++) {

        $url = sb_isset($attachments[$i], 'url');
        if ($url) {
            $file_name = sb_isset($attachments[$i], 'filename');
            $mime = !strpos($file_name, '.');

            $file_name = rand(99999, 999999999)  . strtolower($file_name);
            $url = sb_download_file($url, $file_name, $mime); // should work even not upload

            if (file_exists($pathTemp)) {
                unlink($pathTemp); // Menghapus file

            }

            array_push($attachments_2, [urldecode($mime ? pathinfo($url)['basename'] : $file_name), $url]);
        }
    }

    //         // Send message
    $response = sb_send_message($user_id, $conversation_id, $message, $attachments_2, false);


    sb_messaging_platforms_functions($conversation_id, $message, $attachments_2, $user, ['source' => $platform_code, 'platform_value' => $sender_id, 'extra' => $device, 'conversation_id' => $conversation_id]);


    //         // Queue
    if (sb_get_multi_setting('queue', 'queue-active')) {
        sb_queue($conversation_id, $department);
    }

    //         // Online status

    sb_update_users_last_activity($user_id);

    //     }
    // }

    $GLOBALS['SB_FORCE_ADMIN'] = false;
    return $response;
}
die();
